<?php
// order/lead.php — handles form submissions from contact & popups
header('Content-Type: application/json');
require_once __DIR__ . '/../config.php';

// Helper to fetch from multiple possible keys
function pick($arr, $keys, $default = '') {
    foreach ($keys as $k) {
        if (isset($arr[$k]) && trim($arr[$k]) !== '') return trim($arr[$k]);
    }
    return $default;
}

// Map expected fields from your HTML
$name    = pick($_POST, ['cn','name']);
$email   = pick($_POST, ['em','email']);
$phone   = pick($_POST, ['pn','phone']);
$message = pick($_POST, ['msg','message']);

// Optional tracking/meta fields
$page_url    = $_POST['page_url']    ?? '';
$referer_url = $_POST['referer_url'] ?? '';
$utm_source  = $_POST['utm_source']  ?? '';
$utm_medium  = $_POST['utm_medium']  ?? '';
$utm_campaign= $_POST['utm_campaign']?? '';
$utm_term    = $_POST['utm_term']    ?? '';
$utm_content = $_POST['utm_content'] ?? '';

// Basic validation
if ($name === '' || $email === '') {
    http_response_code(422);
    echo json_encode(['ok' => false, 'error' => 'Name and Email are required.']);
    exit;
}

// Collect all POST as extra JSON (excluding known keys)
$known = ['cn','name','em','email','pn','phone','msg','message','page_url','referer_url','utm_source','utm_medium','utm_campaign','utm_term','utm_content'];
$extra = [];
foreach ($_POST as $k => $v) {
    if (!in_array($k, $known, true)) $extra[$k] = $v;
}
$extra_json = json_encode($extra, JSON_UNESCAPED_UNICODE);

// Insert into database
$sql = "INSERT INTO leads (name, email, phone, message, page_url, referer_url, utm_source, utm_medium, utm_campaign, utm_term, utm_content, extra)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
$stmt = $mysqli->prepare($sql);
if (!$stmt) {
    http_response_code(500);
    echo json_encode(['ok' => false, 'error' => 'Prepare failed: ' . $mysqli->error]);
    exit;
}
$stmt->bind_param(
    "ssssssssssss",
    $name, $email, $phone, $message, $page_url, $referer_url,
    $utm_source, $utm_medium, $utm_campaign, $utm_term, $utm_content, $extra_json
);
$ok = $stmt->execute();

if ($ok) {
    echo json_encode(['ok' => true, 'message' => 'Lead saved successfully']);
} else {
    http_response_code(500);
    echo json_encode(['ok' => false, 'error' => $stmt->error]);
}
$stmt->close();
$mysqli->close();
?>