<?php
header('Content-Type: application/json');
require_once __DIR__ . '/../config.php';

function pick($arr, $keys, $default = '') {
    foreach ($keys as $k) {
        if (isset($arr[$k]) && trim($arr[$k]) !== '') return trim($arr[$k]);
    }
    return $default;
}

$name    = pick($_POST, ['cn','name']);
$email   = pick($_POST, ['em','email']);
$phone   = pick($_POST, ['pn','phone']);
$message = pick($_POST, ['msg','message']);

$page_url    = $_POST['page_url']    ?? '';
$referer_url = $_POST['referer_url'] ?? '';
$utm_source  = $_POST['utm_source']  ?? '';
$utm_medium  = $_POST['utm_medium']  ?? '';
$utm_campaign= $_POST['utm_campaign']?? '';
$utm_term    = $_POST['utm_term']    ?? '';
$utm_content = $_POST['utm_content'] ?? '';

if ($name === '' || $email === '') {
    die("Name and Email are required.");
}

$known = ['cn','name','em','email','pn','phone','msg','message','page_url','referer_url','utm_source','utm_medium','utm_campaign','utm_term','utm_content'];
$extra = [];
foreach ($_POST as $k => $v) {
    if (!in_array($k, $known, true)) $extra[$k] = $v;
}
$extra_json = json_encode($extra, JSON_UNESCAPED_UNICODE);

$sql = "INSERT INTO leads (name, email, phone, message, page_url, referer_url, utm_source, utm_medium, utm_campaign, utm_term, utm_content, extra)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
$stmt = $mysqli->prepare($sql);
if (!$stmt) {
    die("Database Error: " . $mysqli->error);
}
$stmt->bind_param("ssssssssssss",
    $name, $email, $phone, $message, $page_url, $referer_url,
    $utm_source, $utm_medium, $utm_campaign, $utm_term, $utm_content, $extra_json
);
$ok = $stmt->execute();

if ($ok) {
    header("Location: /thankyou.html");
    exit;
} else {
    die("Error: " . $stmt->error);
}
$stmt->close();
$mysqli->close();
?>
